DECLARE @dbName NVARCHAR(128);
DECLARE @sql NVARCHAR(MAX);

-- 1. Procurar pelo banco de dados que contém 'Arquivos' no nome
SELECT TOP 1 @dbName = name
FROM sys.databases
WHERE name LIKE '%Arquivos%';

-- 2. Verificar se encontrou o banco de dados
IF @dbName IS NOT NULL
BEGIN
    -- 3. Construir o script dinâmico para verificar e alterar a tabela
    SET @sql = N'
    IF NOT EXISTS(
        SELECT 1 
        FROM ' + QUOTENAME(@dbName) + N'.dbo.SYSCOLUMNS c
        INNER JOIN ' + QUOTENAME(@dbName) + N'.dbo.sysobjects o ON o.id = c.id
        WHERE o.name = ''EST_NFE_INUTILIZACAO_ARQ_DANFE''
        AND c.name = ''CD_INU''
    )
    BEGIN	
        ALTER TABLE ' + QUOTENAME(@dbName) + N'.dbo.EST_NFE_INUTILIZACAO_ARQ_DANFE ADD CD_INU INT;
    END';

    -- 4. Executar o script dinâmico
    EXEC sp_executesql @sql;
END
ELSE
BEGIN
    PRINT 'Nenhum banco de dados de Arquivos foi encontrado.';
END;


